<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

use app\models\Institutos;

$institutos = Institutos::find()->where(['codigo' => 'inan'])->select(['horario_atencion', 'telefonos'])->one();

$horarios = explode(',', $institutos->horario_atencion);

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">

<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!--script src="//code.jivosite.com/widget/18yHaLXE5j" async></!--script-->



    <style>
        p {
            font-family: 'Montserrat', sans-serif;
            font-weight: 400;
        }

        .btn-primary {
            background-color: #1458A4;
        }

        .carrera-img:hover {
            filter: opacity(.6);
        }

        .heartbeat-button {
            font-size: 18px;
            padding: 10px 20px;
            border: none;
            background-color: #007bff;
            color: #fff;
            border-radius: 5px;
            cursor: pointer;
            animation: heartbeat 2s infinite ease-in-out;
            background-color: #1458A4;
        }

        .nav-link {
            color: white;
        }

        .nav-link:hover {
            font-weight: 500;
            color: white;
        }

        .nav-link2 {
            color: grey;
            text-decoration: none;
            font-size: 13px;
        }

        .logos img {
            width: 85%;
            display: block;
            margin: auto;
        }

        .accordion-button:not(.collapsed) {
            color: white;
            background-color: #1458A4;
        }

        @keyframes heartbeat {

            0%,
            100% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.1);
            }
        }

        .carouselExampleControls {
            padding: 5%;
        }

        .card {
            border: none;
        }

        .btn-primary {}

        .floating-button {
            position: fixed;
            /* Posicionamiento fijo en la pantalla */
            bottom: 50px;
            /* 10px desde la parte inferior de la pantalla */
            right: 10px;
            /* 10px desde la parte derecha de la pantalla */
            z-index: 999;
            /* Asegura que el botón esté por encima de otros elementos */
        }

        .floating-button button {
            background-color: #166da7;
            color: white;
            border: none;
            border-radius: 9px;
            cursor: pointer;
            opacity: 0.9;
            size: 11px;
        }

        .floating-button button:hover {
            background-color: #166da7;
            opacity: 1;
        }
    </style>
</head>

<body class="d-flex flex-column h-100">




    <?php $this->beginBody() ?>

    <!-- MENU PRINCIPAL -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top" style="background-color: #193C78;">
        <div class="container-fluid">
            <a class="navbar-brand" href="site/index">
                <img style="height: 40px;" class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/logoInanBlanco.png' ?>" alt="">
            </a>



            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav ms-auto">

                    <!-- ITEMS DE MENU -->


                    <li class="nav-item">
                        <a href="site/index#ofertaAcademica" class="nav-link">Oferta académica</a>
                    </li>
                    <li class="nav-item">
                        <a href="site/index#cursosEventos" class="nav-link">Cursos y eventos</a>
                    </li>
                    <li class="nav-item">
                        <a href="site/index#departamentos" class="nav-link">Departamentos</a>
                    </li>


                    <li class="nav-item">
                        <?= Html::a(
                            'SGI',
                            ['sgi/index'],
                            ['class' => 'nav-link']
                        )  ?>
                    </li>







                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Biblioteca
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="navbarDropdown" style="padding: 4px; padding-bottom: 12px;">

                            <li>
                                <a href="https://www.ucuenca.edu.ec/servicios/biblioteca/" class="nav-link2">Biblioteca U. Cuenca</a>
                            </li>
                            <li>
                                <hr>
                            </li>
                            <li>
                                <a href="https://www.uasb.edu.ec/biblioteca/" class="nav-link2">Biblioteca U. Andina Simón Bolivar</a>
                            </li>
                            <li>
                                <hr>
                            </li>
                    </li>

                    <li>
                        <?= Html::a(
                            'Biblioteca INAN',
                            ['biblioteca/index'],
                            ['class' => 'nav-link2']
                        )  ?>
                    </li>


                </ul>
                </li>


                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="background-color: #1458A4;border-radius: 35px; padding-right:  19px; padding-left:  19px;">
                        Ingresar
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdown" style="padding: 4px 8px; padding-bottom: 12px;">

                        <li>
                            <a href="https://site2.q10.com/login?ReturnUrl=%2F&aplentId=e5333a78-4bdb-44d8-b4a3-714ff3c7546e" class="nav-link2">Ingresar como estudiante</a>
                        </li>

                        <li>
                            <hr>
                        </li>
                        <li>
                            <a href="https://site2.q10.com/login?ReturnUrl=%2F&aplentId=e5333a78-4bdb-44d8-b4a3-714ff3c7546e" class="nav-link2">Ingresar como<br> docente</a>
                        </li>

                        <li>
                            <hr>
                        </li>

                        <li>
                            <?= Html::a(
                                'Ingresar como administrador',
                                ['site/login'],
                                ['class' => 'nav-link2']
                            )  ?>
                        </li>

                    </ul>
                </li>





                <!-- FIN ITEMS DE MENU -->

                </ul>

            </div>
        </div>
    </nav>




    <main id="main" class="flex-shrink-0" role="main">
        <div class="" style="padding-top: 0px; margin: 0px;">
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs']]) ?>
            <?php endif ?>
            <?= Alert::widget() ?>
            <?= $content ?>
        </div>
    </main>



    <div style="margin-top: 110px;">

        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
            <path fill="#193C78" fill-opacity="1" d="M0,64L60,90.7C120,117,240,171,360,170.7C480,171,600,117,720,122.7C840,128,960,192,1080,208C1200,224,1320,192,1380,176L1440,160L1440,320L1380,320C1320,320,1200,320,1080,320C960,320,840,320,720,320C600,320,480,320,360,320C240,320,120,320,60,320L0,320Z"></path>
        </svg>

    </div>



    <div style="background-color: #193C78;">
        <div class="container">


            <section>



                <div class="row" style="padding-bottom: 50px; color:white; flex-direction: row; align-items: center; ">

                    <div class="col-md-6">
                        <h3 class="display-3">Contáctanos</h3>
                        <p style="margin-bottom: 20px;">¿Tienes alguna inquietud? No dudes en contactarnos, estamos listos para atenderte.</p>

                        <h3>Horario de atención:</h3>
                        <p>
                            <?php foreach ($horarios as $horario) { ?>
                                <?= $horario ?><br>
                            <?php } ?>
                        </p>


                        <p>Llámanos al: <?= $instituto->telefonos ?></p>

                    </div>
                    <div class="col-md-6">
                        <img style="height: 150px; display: block; margin: auto;" class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/logoInanBlanco.png' ?>" alt="">

                    </div>
                </div>

            </section>
        </div>
    </div>


    <footer id="footer" class="mt-auto bg-light">
        <div class="container">
            <div class="row text-muted">
                <div class="col-md-6 text-center text-md-start">&copy; Instituto INAN <?= date('Y') ?></div>
            </div>
        </div>
    </footer>

    <script>
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    </script>

    <?php $this->endBody() ?>
</body>

</html>
<?php $this->endPage() ?>